/**
* \file: AilAudioSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*          J. Michalik / ADITG/SW1 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_AILAUDIOSOURCE_H
#define AAUTO_AILAUDIOSOURCE_H

#include "aauto/AditAudioSource.h"

namespace adit { namespace aauto {

/* forward declaration of internal implementation */
class AilAudioSourceImpl;

/** 
 * @brief AilAudioSource provides AIL specific audio source implementation.*/
class AilAudioSource : public AditAudioSource
{
public:
    /**
     * @brief  Constructor of AilAudioSource
     * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
     * @param  inMessageRouter  inMessageRouter is message router obtained from GalReceiver.
     * @param  inCodec          inCodec is media codec type in GalReceiver.
     *                          (current GalReceiver is fixed "MEDIA_CODEC_AUDIO_PCM") */
    AilAudioSource(uint8_t inSessionId, MessageRouter* inMessageRouter, int inCodec);
    virtual ~AilAudioSource();

    /**
     * @brief Initialize the AilAudioSource. All configuration items must be set.
     *
     * @return true if initialization succeeds.
     *          false if configuration items without default value is not set or initialization
     *          fails. */
    bool init();

    /**
     * @brief  Shutdown the Ail Audio Source */
    void shutdown();

    /** @brief Set configuration for platform and AudioSource-related items.
     * Must be called before init().
     * @param  inKey        The key string for configuration (e.g. "audio-capture-device")
     * @param  inValue      The actual value for configuration (e.g. "device=Microphone periodMs=8")
     * */
    void setConfigItem(string inKey, string inValue);

    /**
     * @brief Register callback interface to receive AudioSource-related notifications.
     * See IAditAudioSourceCallbacks for details.
     *
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditAudioSourceCallbacks* inCallbacks);

private:
    AilAudioSourceImpl* impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_AILAUDIOSOURCE_H */
